from ._pymxs import *
import maxlistener


def print_(*args):
    """
    Print to the max listener window
    """
    maxlistener.write(*args)
######################################################################################
#  'with' context support
######################################################################################
from contextlib import contextmanager

# attime implementation
@contextmanager
def attime(time):
    """
    Perform the block of operations at the specified timeline time.
    (similar to 'at time' in maxscript)
    example:

    with pymxs.attime(30): 
        pymxs.runtime.box()
        pymxs.runtime.teapot()
    """
    ins = _pymxs.__ContextExpr('attime')
    ins(time)
    yield

# atlevel implementation
@contextmanager
def atlevel(node_name):
    """
    Perform the block of operations at the specified scene node.
    (similar to 'at level' and 'in' in maxscript)
    example:

    b1 = pymxs.runtime.box()
    b1.name = "mybox"
    with pymxs.atlevel("mybox"):
        # create a child of mybox
        pymx.runtime.teapot()
    """
    ins = _pymxs.__ContextExpr('atlevel')
    ins(node_name)
    yield

# undo implementation
@contextmanager
def undo(onoff, label = "MAXScript"):
    """
    Activate or deactivate undo for the block of operations.
    (similar to 'undo on' or 'undo off' in maxscript)
    example:
    with pymxs.undo(False):
        pymxs.runtime.box()
        pymxs.runtime.teapot()
    """
    if (onoff):
        ins = _pymxs.__ContextExpr('undoon')
        ins(label)
        try:
            yield
        except Exception as e:
            if (not _pymxs.__ContextExpr.exception_handle(ins)):
                raise e

    else:
        ins = _pymxs.__ContextExpr('undooff')
        ins(label)
        yield

@contextmanager
def quiet(onoff):
    """
    Activate or deactivate quiet mode for the block of operations.
    (similar to maxscript quiet mode)
    example:
    
    with pymxs.quiet(True):
        pymxs.runtime.box()
        pymxs.runtime.teapot()
    """
    save_context = runtime.GetQuietMode()
    runtime.SetQuietMode(onoff)
    yield
    runtime.SetQuietMode(save_context)

@contextmanager
def redraw(onoff):
    """
    Activate or deactivate redraw mode for the block of operations.
    (similar to maxscript redraw mode)
    example:
    
    with pymxs.redraw(True):
        for i in range(100):
            tp = pymxs.runtime.teapot()
            tp.position = pymxs.runtime.point3(i * 5, 0, 0)
    """
    save_context = runtime.IsSceneRedrawDisabled()
    if (onoff):
        runtime.EnableSceneRedraw()
    else:
        runtime.DisableSceneRedraw()
    yield
    if (save_context):
        runtime.DisableSceneRedraw()
    else:
        runtime.EnableSceneRedraw()

@contextmanager
def animate(onoff):
    """
    Activate or deactivate the generation of keyframes for  the
    block of operations.
    (similar to maxscript animate)
    example:

    with pymxs.animate(True):
        with pymxs.attime(10):
            b1 = pymxs.runtime.box()
        with pymxs.attime(20):
            b1.position = pymxs.runtime.point3(10,0,0)

    """
    save_context = runtime.animButtonState
    runtime.animButtonState = onoff
    yield
    runtime.animButtonState = save_context

@contextmanager
def mxstoken():
    """
    Synchronize the block of operations (for multithreading).
    """
    try:
        _pymxs.__mxs_token__(True)
        yield
    finally:
        _pymxs.__mxs_token__()

def mxsreference(o):
    """
    Wrap the provided object as a reference (for pymxs operation that
    require references).
    """
    import warnings
    warnings.warn("Use 'pymxs.byref()' feature instead of 'pymxs.mxsreference()", DeprecationWarning, stacklevel=2)
    class MAXScriptReference:
        def __init__(self, o):
            self._referencedObject = o
    return MAXScriptReference(o)

def byref(o):
    """
    Wrap all provided object as a reference (for pymxs operation that
    require references).
    """
    class MAXScriptByReference:
        def __init__(self, o):
            self._byrefObject = o
    return MAXScriptByReference(o)


def _bootstrap_mxs():
    import importlib
    runtime.python.Import = importlib.import_module
    runtime.python.Reload = importlib.reload
